/*
 * Decompiled with CFR 0.152.
 */
package org.magmafoundation.magma.remapping;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import io.izzel.arclight.api.Unsafe;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.md_5.specialsource.InheritanceMap;
import net.md_5.specialsource.JarMapping;
import net.md_5.specialsource.JarRemapper;
import net.md_5.specialsource.provider.ClassLoaderProvider;
import net.md_5.specialsource.provider.InheritanceProvider;
import net.md_5.specialsource.provider.JointProvider;
import org.magmafoundation.magma.asm.SwitchTableFixer;
import org.magmafoundation.magma.remapping.ClassLoaderRemapper;
import org.magmafoundation.magma.remapping.LenientJarRemapper;
import org.magmafoundation.magma.remapping.MagmaInterfaceInvokerGen;
import org.magmafoundation.magma.remapping.PluginTransformer;
import org.magmafoundation.magma.remapping.adapters.ClassLoaderAdapter;
import org.magmafoundation.magma.remapping.adapters.MagmaRedirectAdapter;
import org.magmafoundation.magma.remapping.handlers.RemapSourceHandler;
import org.magmafoundation.magma.remapping.repos.GlobalClassRepo;
import org.objectweb.asm.tree.ClassNode;

public class MagmaRemapper {
    public static final MagmaRemapper INSTANCE;
    public static final File DUMP;
    private final JarMapping toNmsMapping;
    private final JarMapping toBukkitMapping;
    public final InheritanceMap inheritanceMap;
    private final List<PluginTransformer> transformerList = new ArrayList<PluginTransformer>();
    private final JarRemapper toBukkitRemapper;
    private final JarRemapper toNmsRemapper;
    private static long pkgOffset;
    private static long clOffset;
    private static long mdOffset;
    private static long fdOffset;
    private static long mapOffset;

    public MagmaRemapper() throws Exception {
        this.toNmsMapping = new JarMapping();
        this.toBukkitMapping = new JarMapping();
        this.inheritanceMap = new InheritanceMap();
        this.toNmsMapping.loadMappings(new BufferedReader(new InputStreamReader(MagmaRemapper.class.getClassLoader().getResourceAsStream("mappings/nms.srg"))), null, null, false);
        String content = new String(MagmaRemapper.class.getClassLoader().getResourceAsStream("mappings/nms.srg").readAllBytes(), StandardCharsets.UTF_8);
        int i = content.indexOf("net/minecraft/server/level/ChunkMap net/minecraft/server/level/ChunkTracker");
        String nextSection = content.substring(i).lines().skip(1L).dropWhile(it -> it.startsWith("\t")).findFirst().orElseThrow();
        int nextIndex = content.indexOf(nextSection);
        this.toBukkitMapping.loadMappings(new BufferedReader(new StringReader(content.substring(0, i) + content.substring(nextIndex))), null, null, true);
        this.toBukkitMapping.loadMappings(new BufferedReader(new StringReader(content.substring(i, nextIndex))), null, null, true);
        BiMap inverseClassMap = HashBiMap.create((Map)this.toNmsMapping.classes).inverse();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(MagmaRemapper.class.getClassLoader().getResourceAsStream("mappings/inheritanceMap.txt")));){
            this.inheritanceMap.load(reader, inverseClassMap);
        }
        JointProvider inheritanceProvider = new JointProvider();
        inheritanceProvider.add((InheritanceProvider)this.inheritanceMap);
        inheritanceProvider.add((InheritanceProvider)new ClassLoaderProvider(ClassLoader.getSystemClassLoader()));
        this.toNmsMapping.setFallbackInheritanceProvider((InheritanceProvider)inheritanceProvider);
        this.toBukkitMapping.setFallbackInheritanceProvider((InheritanceProvider)inheritanceProvider);
        this.transformerList.add(MagmaInterfaceInvokerGen.INSTANCE);
        this.transformerList.add(MagmaRedirectAdapter.INSTANCE);
        this.transformerList.add(ClassLoaderAdapter.INSTANCE);
        this.transformerList.add((node, remapper) -> SwitchTableFixer.handleClass((ClassNode)node));
        this.toBukkitMapping.setFallbackInheritanceProvider((InheritanceProvider)GlobalClassRepo.inheritanceProvider());
        this.toBukkitRemapper = new LenientJarRemapper(this.toBukkitMapping);
        this.toNmsRemapper = new LenientJarRemapper(this.toNmsMapping);
        RemapSourceHandler.register();
    }

    public static ClassLoaderRemapper createClassLoaderRemapper(ClassLoader classLoader) {
        return new ClassLoaderRemapper(INSTANCE.copyOf(MagmaRemapper.INSTANCE.toNmsMapping), INSTANCE.copyOf(MagmaRemapper.INSTANCE.toBukkitMapping), classLoader);
    }

    public static JarRemapper getResourceMapper() {
        return MagmaRemapper.INSTANCE.toBukkitRemapper;
    }

    public static JarRemapper getNmsMapper() {
        return MagmaRemapper.INSTANCE.toNmsRemapper;
    }

    public List<PluginTransformer> getTransformerList() {
        return this.transformerList;
    }

    private JarMapping copyOf(JarMapping mapping) {
        JarMapping jarMapping = new JarMapping();
        Unsafe.putObject((Object)jarMapping, (long)pkgOffset, (Object)Unsafe.getObject((Object)mapping, (long)pkgOffset));
        Unsafe.putObject((Object)jarMapping, (long)clOffset, (Object)Unsafe.getObject((Object)mapping, (long)clOffset));
        Unsafe.putObject((Object)jarMapping, (long)mdOffset, (Object)Unsafe.getObject((Object)mapping, (long)mdOffset));
        Unsafe.putObject((Object)jarMapping, (long)fdOffset, (Object)Unsafe.getObject((Object)mapping, (long)fdOffset));
        Unsafe.putObject((Object)jarMapping, (long)mapOffset, (Object)Unsafe.getObject((Object)mapping, (long)mapOffset));
        return jarMapping;
    }

    static {
        try {
            INSTANCE = new MagmaRemapper();
            DUMP = null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            pkgOffset = Unsafe.objectFieldOffset((Field)JarMapping.class.getField("packages"));
            clOffset = Unsafe.objectFieldOffset((Field)JarMapping.class.getField("classes"));
            mdOffset = Unsafe.objectFieldOffset((Field)JarMapping.class.getField("methods"));
            fdOffset = Unsafe.objectFieldOffset((Field)JarMapping.class.getField("fields"));
            mapOffset = Unsafe.objectFieldOffset((Field)JarMapping.class.getDeclaredField("inheritanceMap"));
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
    }
}

